/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeVisitor;

public class PointerType
extends Type
implements Cloneable {
    private final Type targetType;
    private String computedName;
    private boolean hasTypedefedName = false;

    public PointerType(SizeThunk sizeThunk, Type type, int n) {
        this(sizeThunk, type, n, false, null);
    }

    private PointerType(SizeThunk sizeThunk, Type type, int n, boolean bl, String string) {
        super(type.getName() + " *", sizeThunk, n);
        this.targetType = type;
        if (bl) {
            this.setName(string);
        }
    }

    @Override
    public int hashCode() {
        return this.targetType.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof PointerType)) {
            return false;
        }
        PointerType pointerType = (PointerType)object;
        return this.getSize() == pointerType.getSize() && this.getCVAttributes() == pointerType.getCVAttributes() && this.targetType.equals(pointerType.targetType);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.hasTypedefedName = true;
    }

    @Override
    public String getName(boolean bl) {
        if (this.hasTypedefedName) {
            return super.getName(bl);
        }
        if (this.computedName == null) {
            this.computedName = this.targetType.getName(bl) + " *";
            this.computedName = this.computedName.intern();
        }
        if (!bl) {
            return this.computedName;
        }
        return this.targetType.getName(bl) + " * " + this.getCVAttributesString();
    }

    public boolean hasTypedefedName() {
        return this.hasTypedefedName;
    }

    @Override
    public PointerType asPointer() {
        return this;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public Type getLastTargetType() {
        if (this.targetType.isPointer()) {
            return ((PointerType)this.targetType).getLastTargetType();
        }
        return this.targetType;
    }

    @Override
    public boolean isFunctionPointer() {
        return this.targetType.isFunction();
    }

    @Override
    public String toString() {
        if (this.hasTypedefedName) {
            return super.getName(true);
        }
        if (!this.targetType.isFunction()) {
            return this.targetType.toString() + " * " + this.getCVAttributesString();
        }
        return this.toString(null, null);
    }

    public String toString(String string, String string2) {
        if (!this.targetType.isFunction()) {
            throw new RuntimeException("<Internal error or misuse> This method is only for use when printing function pointers");
        }
        return ((FunctionType)this.targetType).toString(string, string2, false, true);
    }

    @Override
    public void visit(TypeVisitor typeVisitor) {
        super.visit(typeVisitor);
        this.targetType.visit(typeVisitor);
    }

    @Override
    Type newCVVariant(int n) {
        return new PointerType(this.getSize(), this.targetType, n, this.hasTypedefedName, this.hasTypedefedName ? this.getName() : null);
    }
}

